/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.vw.toolkit.runtime.VWDuration;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWSIMStatisticsTableCellRenderer
extends DefaultTableCellRenderer {
    private static DateFormat s_dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);
    private static DecimalFormat s_decimalFormat = new DecimalFormat("###0.00", new DecimalFormatSymbols(Locale.getDefault()));

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        component.applyComponentOrientation(compOrientation);
        String string = null;
        ((JLabel)component).setText("");
        ((JLabel)component).setIcon(null);
        if (compOrientation.isLeftToRight()) {
            ((JLabel)component).setHorizontalAlignment(2);
        } else {
            ((JLabel)component).setHorizontalAlignment(4);
        }
        if (value != null) {
            if (value instanceof Calendar || value instanceof Date) {
                Date date = null;
                if (value instanceof Calendar) {
                    date = ((Calendar)value).getTime();
                } else if (value instanceof Date) {
                    date = (Date)value;
                }
                if (date != null) {
                    string = s_dateTimeFormatter.format(date);
                    ((JLabel)component).setText(string);
                }
            } else if (value instanceof Integer) {
                Integer integer = (Integer)value;
                string = integer != 0 ? integer.toString() : null;
                ((JLabel)component).setText(string);
                ((JLabel)component).setHorizontalAlignment(0);
            } else if (value instanceof Double) {
                Double doubleValue = (Double)value;
                string = doubleValue != 0.0 ? s_decimalFormat.format(doubleValue + 0.005) : null;
                ((JLabel)component).setText(string);
                ((JLabel)component).setHorizontalAlignment(0);
            } else if (value instanceof VWDuration) {
                VWDuration duration = (VWDuration)value;
                string = duration.toString();
                ((JLabel)component).setText(string);
            } else if (value instanceof JLabel) {
                JLabel label = (JLabel)value;
                string = label.getText();
                ((JLabel)component).setText(string);
                ((JLabel)component).setIcon(label.getIcon());
            } else if (value instanceof String) {
                String s = new String("");
                string = (String)value;
                StringTokenizer st = new StringTokenizer(string, "\n");
                if (st.hasMoreTokens()) {
                    s = st.nextToken();
                    while (st.hasMoreTokens()) {
                        s = s + "   " + st.nextToken();
                    }
                }
                ((JLabel)component).setText(s);
            }
        }
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(VWStringUtils.formatToolTip(string, 0));
        }
        return component;
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        String string = null;
        if (value instanceof Calendar || value instanceof Date) {
            Date date = null;
            if (value instanceof Calendar) {
                date = ((Calendar)value).getTime();
            } else if (value instanceof Date) {
                date = (Date)value;
            }
            if (date != null) {
                string = s_dateTimeFormatter.format(date);
            }
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            string = integer.toString();
        } else if (value instanceof VWDuration) {
            VWDuration duration = (VWDuration)value;
            string = duration.toString();
        } else if (value instanceof JLabel) {
            JLabel label = (JLabel)value;
            string = label.getText();
        } else if (value instanceof String) {
            string = (String)value;
        }
        return string;
    }

    public static ImageIcon getIcon(Object value) {
        if (value == null) {
            return null;
        }
        ImageIcon icon = null;
        if (value instanceof JLabel) {
            icon = (ImageIcon)((JLabel)value).getIcon();
        }
        return icon;
    }
}

